package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LabelingJobInputConfig(
    dataSource: zio.aws.sagemaker.model.LabelingJobDataSource,
    dataAttributes: Optional[
      zio.aws.sagemaker.model.LabelingJobDataAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig = {
    import LabelingJobInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig
      .builder()
      .dataSource(dataSource.buildAwsValue())
      .optionallyWith(dataAttributes.map(value => value.buildAwsValue()))(
        _.dataAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobInputConfig.wrap(buildAwsValue())
}
object LabelingJobInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobInputConfig =
      zio.aws.sagemaker.model.LabelingJobInputConfig(
        dataSource.asEditable,
        dataAttributes.map(value => value.asEditable)
      )
    def dataSource: zio.aws.sagemaker.model.LabelingJobDataSource.ReadOnly
    def dataAttributes
        : Optional[zio.aws.sagemaker.model.LabelingJobDataAttributes.ReadOnly]
    def getDataSource: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.LabelingJobDataSource.ReadOnly
    ] = ZIO.succeed(dataSource)
    def getDataAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobDataAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dataAttributes", dataAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig
  ) extends zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly {
    override val dataSource
        : zio.aws.sagemaker.model.LabelingJobDataSource.ReadOnly =
      zio.aws.sagemaker.model.LabelingJobDataSource.wrap(impl.dataSource())
    override val dataAttributes
        : Optional[zio.aws.sagemaker.model.LabelingJobDataAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAttributes())
        .map(value =>
          zio.aws.sagemaker.model.LabelingJobDataAttributes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig
  ): zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly = new Wrapper(impl)
}
