package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait InferenceExperimentStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus
}
object InferenceExperimentStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus
  ): zio.aws.sagemaker.model.InferenceExperimentStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.CREATED =>
      val r = Created
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.STARTING =>
      val r = Starting
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.CANCELLED =>
      val r = Cancelled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.CREATING
  }
  case object Created
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.CREATED
  }
  case object Updating
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.UPDATING
  }
  case object Running
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.RUNNING
  }
  case object Starting
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.STARTING
  }
  case object Stopping
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.STOPPING
  }
  case object Completed
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.COMPLETED
  }
  case object Cancelled
      extends zio.aws.sagemaker.model.InferenceExperimentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus =
      software.amazon.awssdk.services.sagemaker.model.InferenceExperimentStatus.CANCELLED
  }
}
