package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{HubContentArn, HubArn}
import scala.jdk.CollectionConverters.*
final case class ImportHubContentResponse(
    hubArn: HubArn,
    hubContentArn: HubContentArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse = {
    import ImportHubContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse
      .builder()
      .hubArn(HubArn.unwrap(hubArn): java.lang.String)
      .hubContentArn(HubContentArn.unwrap(hubContentArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ImportHubContentResponse.ReadOnly =
    zio.aws.sagemaker.model.ImportHubContentResponse.wrap(buildAwsValue())
}
object ImportHubContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ImportHubContentResponse =
      zio.aws.sagemaker.model.ImportHubContentResponse(hubArn, hubContentArn)
    def hubArn: HubArn
    def hubContentArn: HubContentArn
    def getHubArn: ZIO[Any, Nothing, HubArn] = ZIO.succeed(hubArn)
    def getHubContentArn: ZIO[Any, Nothing, HubContentArn] =
      ZIO.succeed(hubContentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse
  ) extends zio.aws.sagemaker.model.ImportHubContentResponse.ReadOnly {
    override val hubArn: HubArn =
      zio.aws.sagemaker.model.primitives.HubArn(impl.hubArn())
    override val hubContentArn: HubContentArn =
      zio.aws.sagemaker.model.primitives.HubContentArn(impl.hubContentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse
  ): zio.aws.sagemaker.model.ImportHubContentResponse.ReadOnly = new Wrapper(
    impl
  )
}
