package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  HyperbandStrategyMaxResource,
  HyperbandStrategyMinResource
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HyperbandStrategyConfig(
    minResource: Optional[HyperbandStrategyMinResource] = Optional.Absent,
    maxResource: Optional[HyperbandStrategyMaxResource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperbandStrategyConfig = {
    import HyperbandStrategyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperbandStrategyConfig
      .builder()
      .optionallyWith(
        minResource.map(value =>
          HyperbandStrategyMinResource.unwrap(value): Integer
        )
      )(_.minResource)
      .optionallyWith(
        maxResource.map(value =>
          HyperbandStrategyMaxResource.unwrap(value): Integer
        )
      )(_.maxResource)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HyperbandStrategyConfig.ReadOnly =
    zio.aws.sagemaker.model.HyperbandStrategyConfig.wrap(buildAwsValue())
}
object HyperbandStrategyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperbandStrategyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperbandStrategyConfig =
      zio.aws.sagemaker.model.HyperbandStrategyConfig(
        minResource.map(value => value),
        maxResource.map(value => value)
      )
    def minResource: Optional[HyperbandStrategyMinResource]
    def maxResource: Optional[HyperbandStrategyMaxResource]
    def getMinResource: ZIO[Any, AwsError, HyperbandStrategyMinResource] =
      AwsError.unwrapOptionField("minResource", minResource)
    def getMaxResource: ZIO[Any, AwsError, HyperbandStrategyMaxResource] =
      AwsError.unwrapOptionField("maxResource", maxResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperbandStrategyConfig
  ) extends zio.aws.sagemaker.model.HyperbandStrategyConfig.ReadOnly {
    override val minResource: Optional[HyperbandStrategyMinResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minResource())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HyperbandStrategyMinResource(value)
        )
    override val maxResource: Optional[HyperbandStrategyMaxResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResource())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HyperbandStrategyMaxResource(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperbandStrategyConfig
  ): zio.aws.sagemaker.model.HyperbandStrategyConfig.ReadOnly = new Wrapper(
    impl
  )
}
