package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class ExperimentConfig(
    experimentName: Optional[ExperimentEntityName] = Optional.Absent,
    trialName: Optional[ExperimentEntityName] = Optional.Absent,
    trialComponentDisplayName: Optional[ExperimentEntityName] = Optional.Absent,
    runName: Optional[ExperimentEntityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ExperimentConfig = {
    import ExperimentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ExperimentConfig
      .builder()
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        trialComponentDisplayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialComponentDisplayName)
      .optionallyWith(
        runName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.runName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ExperimentConfig.ReadOnly =
    zio.aws.sagemaker.model.ExperimentConfig.wrap(buildAwsValue())
}
object ExperimentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ExperimentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ExperimentConfig =
      zio.aws.sagemaker.model.ExperimentConfig(
        experimentName.map(value => value),
        trialName.map(value => value),
        trialComponentDisplayName.map(value => value),
        runName.map(value => value)
      )
    def experimentName: Optional[ExperimentEntityName]
    def trialName: Optional[ExperimentEntityName]
    def trialComponentDisplayName: Optional[ExperimentEntityName]
    def runName: Optional[ExperimentEntityName]
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getTrialComponentDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField(
        "trialComponentDisplayName",
        trialComponentDisplayName
      )
    def getRunName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("runName", runName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ExperimentConfig
  ) extends zio.aws.sagemaker.model.ExperimentConfig.ReadOnly {
    override val experimentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialComponentDisplayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val runName: Optional[ExperimentEntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.runName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ExperimentConfig
  ): zio.aws.sagemaker.model.ExperimentConfig.ReadOnly = new Wrapper(impl)
}
