package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointConfigSortKey {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey
}
object EndpointConfigSortKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey
  ): zio.aws.sagemaker.model.EndpointConfigSortKey = value match {
    case software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey.CREATION_TIME =>
      val r = CreationTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.EndpointConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.EndpointConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey.NAME
  }
  case object CreationTime
      extends zio.aws.sagemaker.model.EndpointConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey.CREATION_TIME
  }
}
