package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{Timestamp, Integer}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EdgeDeploymentStatus(
    stageStatus: zio.aws.sagemaker.model.StageStatus,
    edgeDeploymentSuccessInStage: Integer,
    edgeDeploymentPendingInStage: Integer,
    edgeDeploymentFailedInStage: Integer,
    edgeDeploymentStatusMessage: Optional[String] = Optional.Absent,
    edgeDeploymentStageStartTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentStatus = {
    import EdgeDeploymentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentStatus
      .builder()
      .stageStatus(stageStatus.unwrap)
      .edgeDeploymentSuccessInStage(
        edgeDeploymentSuccessInStage: java.lang.Integer
      )
      .edgeDeploymentPendingInStage(
        edgeDeploymentPendingInStage: java.lang.Integer
      )
      .edgeDeploymentFailedInStage(
        edgeDeploymentFailedInStage: java.lang.Integer
      )
      .optionallyWith(
        edgeDeploymentStatusMessage.map(value => value: java.lang.String)
      )(_.edgeDeploymentStatusMessage)
      .optionallyWith(
        edgeDeploymentStageStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.edgeDeploymentStageStartTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeDeploymentStatus.ReadOnly =
    zio.aws.sagemaker.model.EdgeDeploymentStatus.wrap(buildAwsValue())
}
object EdgeDeploymentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeDeploymentStatus =
      zio.aws.sagemaker.model.EdgeDeploymentStatus(
        stageStatus,
        edgeDeploymentSuccessInStage,
        edgeDeploymentPendingInStage,
        edgeDeploymentFailedInStage,
        edgeDeploymentStatusMessage.map(value => value),
        edgeDeploymentStageStartTime.map(value => value)
      )
    def stageStatus: zio.aws.sagemaker.model.StageStatus
    def edgeDeploymentSuccessInStage: Integer
    def edgeDeploymentPendingInStage: Integer
    def edgeDeploymentFailedInStage: Integer
    def edgeDeploymentStatusMessage: Optional[String]
    def edgeDeploymentStageStartTime: Optional[Timestamp]
    def getStageStatus: ZIO[Any, Nothing, zio.aws.sagemaker.model.StageStatus] =
      ZIO.succeed(stageStatus)
    def getEdgeDeploymentSuccessInStage: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(edgeDeploymentSuccessInStage)
    def getEdgeDeploymentPendingInStage: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(edgeDeploymentPendingInStage)
    def getEdgeDeploymentFailedInStage: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(edgeDeploymentFailedInStage)
    def getEdgeDeploymentStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "edgeDeploymentStatusMessage",
        edgeDeploymentStatusMessage
      )
    def getEdgeDeploymentStageStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "edgeDeploymentStageStartTime",
        edgeDeploymentStageStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentStatus
  ) extends zio.aws.sagemaker.model.EdgeDeploymentStatus.ReadOnly {
    override val stageStatus: zio.aws.sagemaker.model.StageStatus =
      zio.aws.sagemaker.model.StageStatus.wrap(impl.stageStatus())
    override val edgeDeploymentSuccessInStage: Integer =
      impl.edgeDeploymentSuccessInStage(): Integer
    override val edgeDeploymentPendingInStage: Integer =
      impl.edgeDeploymentPendingInStage(): Integer
    override val edgeDeploymentFailedInStage: Integer =
      impl.edgeDeploymentFailedInStage(): Integer
    override val edgeDeploymentStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeDeploymentStatusMessage())
        .map(value => value: String)
    override val edgeDeploymentStageStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeDeploymentStageStartTime())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentStatus
  ): zio.aws.sagemaker.model.EdgeDeploymentStatus.ReadOnly = new Wrapper(impl)
}
