package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{UserProfileName, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteUserProfileRequest(
    domainId: DomainId,
    userProfileName: UserProfileName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest = {
    import DeleteUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteUserProfileRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteUserProfileRequest.wrap(buildAwsValue())
}
object DeleteUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteUserProfileRequest =
      zio.aws.sagemaker.model
        .DeleteUserProfileRequest(domainId, userProfileName)
    def domainId: DomainId
    def userProfileName: UserProfileName
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest
  ) extends zio.aws.sagemaker.model.DeleteUserProfileRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest
  ): zio.aws.sagemaker.model.DeleteUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
