package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ArtifactArn
import scala.jdk.CollectionConverters.*
final case class DeleteArtifactRequest(
    artifactArn: Optional[ArtifactArn] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ArtifactSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest = {
    import DeleteArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteArtifactRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteArtifactRequest.wrap(buildAwsValue())
}
object DeleteArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteArtifactRequest =
      zio.aws.sagemaker.model.DeleteArtifactRequest(
        artifactArn.map(value => value),
        source.map(value => value.asEditable)
      )
    def artifactArn: Optional[ArtifactArn]
    def source: Optional[zio.aws.sagemaker.model.ArtifactSource.ReadOnly]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest
  ) extends zio.aws.sagemaker.model.DeleteArtifactRequest.ReadOnly {
    override val artifactArn: Optional[ArtifactArn] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
    override val source
        : Optional[zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ArtifactSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest
  ): zio.aws.sagemaker.model.DeleteArtifactRequest.ReadOnly = new Wrapper(impl)
}
