package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  TrainingJobName,
  RoleArn,
  TrainingEnvironmentKey,
  TrainingEnvironmentValue,
  HyperParameterKey,
  HyperParameterValue
}
import scala.jdk.CollectionConverters.*
final case class CreateTrainingJobRequest(
    trainingJobName: TrainingJobName,
    hyperParameters: Optional[Map[HyperParameterKey, HyperParameterValue]] =
      Optional.Absent,
    algorithmSpecification: zio.aws.sagemaker.model.AlgorithmSpecification,
    roleArn: RoleArn,
    inputDataConfig: Optional[Iterable[zio.aws.sagemaker.model.Channel]] =
      Optional.Absent,
    outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig,
    resourceConfig: zio.aws.sagemaker.model.ResourceConfig,
    vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig] = Optional.Absent,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    enableNetworkIsolation: Optional[Boolean] = Optional.Absent,
    enableInterContainerTrafficEncryption: Optional[Boolean] = Optional.Absent,
    enableManagedSpotTraining: Optional[Boolean] = Optional.Absent,
    checkpointConfig: Optional[zio.aws.sagemaker.model.CheckpointConfig] =
      Optional.Absent,
    debugHookConfig: Optional[zio.aws.sagemaker.model.DebugHookConfig] =
      Optional.Absent,
    debugRuleConfigurations: Optional[
      Iterable[zio.aws.sagemaker.model.DebugRuleConfiguration]
    ] = Optional.Absent,
    tensorBoardOutputConfig: Optional[
      zio.aws.sagemaker.model.TensorBoardOutputConfig
    ] = Optional.Absent,
    experimentConfig: Optional[zio.aws.sagemaker.model.ExperimentConfig] =
      Optional.Absent,
    profilerConfig: Optional[zio.aws.sagemaker.model.ProfilerConfig] =
      Optional.Absent,
    profilerRuleConfigurations: Optional[
      Iterable[zio.aws.sagemaker.model.ProfilerRuleConfiguration]
    ] = Optional.Absent,
    environment: Optional[
      Map[TrainingEnvironmentKey, TrainingEnvironmentValue]
    ] = Optional.Absent,
    retryStrategy: Optional[zio.aws.sagemaker.model.RetryStrategy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest = {
    import CreateTrainingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HyperParameterKey.unwrap(
                key
              ): java.lang.String) -> (HyperParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .algorithmSpecification(algorithmSpecification.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .resourceConfig(resourceConfig.buildAwsValue())
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableManagedSpotTraining.map(value => value: java.lang.Boolean)
      )(_.enableManagedSpotTraining)
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .optionallyWith(debugHookConfig.map(value => value.buildAwsValue()))(
        _.debugHookConfig
      )
      .optionallyWith(
        debugRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.debugRuleConfigurations)
      .optionallyWith(
        tensorBoardOutputConfig.map(value => value.buildAwsValue())
      )(_.tensorBoardOutputConfig)
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .optionallyWith(profilerConfig.map(value => value.buildAwsValue()))(
        _.profilerConfig
      )
      .optionallyWith(
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profilerRuleConfigurations)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TrainingEnvironmentKey
                .unwrap(key): java.lang.String) -> (TrainingEnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTrainingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateTrainingJobRequest.wrap(buildAwsValue())
}
object CreateTrainingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTrainingJobRequest =
      zio.aws.sagemaker.model.CreateTrainingJobRequest(
        trainingJobName,
        hyperParameters.map(value => value),
        algorithmSpecification.asEditable,
        roleArn,
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputDataConfig.asEditable,
        resourceConfig.asEditable,
        vpcConfig.map(value => value.asEditable),
        stoppingCondition.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableNetworkIsolation.map(value => value),
        enableInterContainerTrafficEncryption.map(value => value),
        enableManagedSpotTraining.map(value => value),
        checkpointConfig.map(value => value.asEditable),
        debugHookConfig.map(value => value.asEditable),
        debugRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tensorBoardOutputConfig.map(value => value.asEditable),
        experimentConfig.map(value => value.asEditable),
        profilerConfig.map(value => value.asEditable),
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environment.map(value => value),
        retryStrategy.map(value => value.asEditable)
      )
    def trainingJobName: TrainingJobName
    def hyperParameters: Optional[Map[HyperParameterKey, HyperParameterValue]]
    def algorithmSpecification
        : zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly
    def roleArn: RoleArn
    def inputDataConfig
        : Optional[List[zio.aws.sagemaker.model.Channel.ReadOnly]]
    def outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig.ReadOnly
    def resourceConfig: zio.aws.sagemaker.model.ResourceConfig.ReadOnly
    def vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def enableNetworkIsolation: Optional[Boolean]
    def enableInterContainerTrafficEncryption: Optional[Boolean]
    def enableManagedSpotTraining: Optional[Boolean]
    def checkpointConfig
        : Optional[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly]
    def debugHookConfig
        : Optional[zio.aws.sagemaker.model.DebugHookConfig.ReadOnly]
    def debugRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly]
    ]
    def tensorBoardOutputConfig
        : Optional[zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly]
    def experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def profilerConfig
        : Optional[zio.aws.sagemaker.model.ProfilerConfig.ReadOnly]
    def profilerRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ]
    def environment
        : Optional[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]]
    def retryStrategy: Optional[zio.aws.sagemaker.model.RetryStrategy.ReadOnly]
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
    def getHyperParameters
        : ZIO[Any, AwsError, Map[HyperParameterKey, HyperParameterValue]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getAlgorithmSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly
    ] = ZIO.succeed(algorithmSpecification)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getInputDataConfig
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getResourceConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      ZIO.succeed(resourceConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableManagedSpotTraining: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableManagedSpotTraining", enableManagedSpotTraining)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getDebugHookConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DebugHookConfig.ReadOnly] =
      AwsError.unwrapOptionField("debugHookConfig", debugHookConfig)
    def getDebugRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "debugRuleConfigurations",
      debugRuleConfigurations
    )
    def getTensorBoardOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tensorBoardOutputConfig",
      tensorBoardOutputConfig
    )
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getProfilerConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProfilerConfig.ReadOnly] =
      AwsError.unwrapOptionField("profilerConfig", profilerConfig)
    def getProfilerRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "profilerRuleConfigurations",
      profilerRuleConfigurations
    )
    def getEnvironment: ZIO[Any, AwsError, Map[
      TrainingEnvironmentKey,
      TrainingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest
  ) extends zio.aws.sagemaker.model.CreateTrainingJobRequest.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
    override val hyperParameters
        : Optional[Map[HyperParameterKey, HyperParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.HyperParameterKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
            })
            .toMap
        )
    override val algorithmSpecification
        : zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly =
      zio.aws.sagemaker.model.AlgorithmSpecification
        .wrap(impl.algorithmSpecification())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val inputDataConfig
        : Optional[List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Channel.wrap(item)
          }.toList
        )
    override val outputDataConfig
        : zio.aws.sagemaker.model.OutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val resourceConfig
        : zio.aws.sagemaker.model.ResourceConfig.ReadOnly =
      zio.aws.sagemaker.model.ResourceConfig.wrap(impl.resourceConfig())
    override val vpcConfig
        : Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val enableNetworkIsolation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNetworkIsolation())
        .map(value => value: Boolean)
    override val enableInterContainerTrafficEncryption: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableInterContainerTrafficEncryption())
        .map(value => value: Boolean)
    override val enableManagedSpotTraining: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableManagedSpotTraining())
        .map(value => value: Boolean)
    override val checkpointConfig
        : Optional[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointConfig())
        .map(value => zio.aws.sagemaker.model.CheckpointConfig.wrap(value))
    override val debugHookConfig
        : Optional[zio.aws.sagemaker.model.DebugHookConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.debugHookConfig())
        .map(value => zio.aws.sagemaker.model.DebugHookConfig.wrap(value))
    override val debugRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.debugRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DebugRuleConfiguration.wrap(item)
        }.toList
      )
    override val tensorBoardOutputConfig
        : Optional[zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tensorBoardOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.TensorBoardOutputConfig.wrap(value)
        )
    override val experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentConfig())
        .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val profilerConfig
        : Optional[zio.aws.sagemaker.model.ProfilerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profilerConfig())
        .map(value => zio.aws.sagemaker.model.ProfilerConfig.wrap(value))
    override val profilerRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.profilerRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProfilerRuleConfiguration.wrap(item)
        }.toList
      )
    override val environment
        : Optional[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.TrainingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .TrainingEnvironmentValue(value)
            })
            .toMap
        )
    override val retryStrategy
        : Optional[zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryStrategy())
        .map(value => zio.aws.sagemaker.model.RetryStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest
  ): zio.aws.sagemaker.model.CreateTrainingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
