package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ConditionOutcome {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ConditionOutcome
}
object ConditionOutcome {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ConditionOutcome
  ): zio.aws.sagemaker.model.ConditionOutcome = value match {
    case software.amazon.awssdk.services.sagemaker.model.ConditionOutcome.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ConditionOutcome.TRUE =>
      val r = True
      r
    case software.amazon.awssdk.services.sagemaker.model.ConditionOutcome.FALSE =>
      val r = False
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ConditionOutcome {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ConditionOutcome =
      software.amazon.awssdk.services.sagemaker.model.ConditionOutcome.UNKNOWN_TO_SDK_VERSION
  }
  case object True extends zio.aws.sagemaker.model.ConditionOutcome {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ConditionOutcome =
      software.amazon.awssdk.services.sagemaker.model.ConditionOutcome.TRUE
  }
  case object False extends zio.aws.sagemaker.model.ConditionOutcome {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ConditionOutcome =
      software.amazon.awssdk.services.sagemaker.model.ConditionOutcome.FALSE
  }
}
