package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{DirectoryPath, S3Uri}
import scala.jdk.CollectionConverters.*
final case class CheckpointConfig(
    s3Uri: S3Uri,
    localPath: Optional[DirectoryPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CheckpointConfig = {
    import CheckpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CheckpointConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        localPath.map(value => DirectoryPath.unwrap(value): java.lang.String)
      )(_.localPath)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CheckpointConfig.ReadOnly =
    zio.aws.sagemaker.model.CheckpointConfig.wrap(buildAwsValue())
}
object CheckpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CheckpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CheckpointConfig =
      zio.aws.sagemaker.model
        .CheckpointConfig(s3Uri, localPath.map(value => value))
    def s3Uri: S3Uri
    def localPath: Optional[DirectoryPath]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getLocalPath: ZIO[Any, AwsError, DirectoryPath] =
      AwsError.unwrapOptionField("localPath", localPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CheckpointConfig
  ) extends zio.aws.sagemaker.model.CheckpointConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val localPath: Optional[DirectoryPath] = zio.aws.core.internal
      .optionalFromNullable(impl.localPath())
      .map(value => zio.aws.sagemaker.model.primitives.DirectoryPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CheckpointConfig
  ): zio.aws.sagemaker.model.CheckpointConfig.ReadOnly = new Wrapper(impl)
}
