package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters.*
final case class AutoMLCandidateGenerationConfig(
    featureSpecificationS3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig = {
    import AutoMLCandidateGenerationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
      .builder()
      .optionallyWith(
        featureSpecificationS3Uri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.featureSpecificationS3Uri)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig
      .wrap(buildAwsValue())
}
object AutoMLCandidateGenerationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig =
      zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig(
        featureSpecificationS3Uri.map(value => value)
      )
    def featureSpecificationS3Uri: Optional[S3Uri]
    def getFeatureSpecificationS3Uri: ZIO[Any, AwsError, S3Uri] = AwsError
      .unwrapOptionField("featureSpecificationS3Uri", featureSpecificationS3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
  ) extends zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly {
    override val featureSpecificationS3Uri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureSpecificationS3Uri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
  ): zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly =
    new Wrapper(impl)
}
