package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AuthMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AuthMode
}
object AuthMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AuthMode
  ): zio.aws.sagemaker.model.AuthMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.AuthMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AuthMode.SSO =>
      val r = SSO
      r
    case software.amazon.awssdk.services.sagemaker.model.AuthMode.IAM =>
      val r = IAM
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AuthMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AuthMode =
      software.amazon.awssdk.services.sagemaker.model.AuthMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SSO extends zio.aws.sagemaker.model.AuthMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AuthMode =
      software.amazon.awssdk.services.sagemaker.model.AuthMode.SSO
  }
  case object IAM extends zio.aws.sagemaker.model.AuthMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AuthMode =
      software.amazon.awssdk.services.sagemaker.model.AuthMode.IAM
  }
}
