package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait VendorGuidance {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.VendorGuidance
}
object VendorGuidance {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.VendorGuidance
  ): zio.aws.sagemaker.model.VendorGuidance = value match {
    case software.amazon.awssdk.services.sagemaker.model.VendorGuidance.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.VendorGuidance.NOT_PROVIDED =>
      val r = NOT_PROVIDED
      r
    case software.amazon.awssdk.services.sagemaker.model.VendorGuidance.STABLE =>
      val r = STABLE
      r
    case software.amazon.awssdk.services.sagemaker.model.VendorGuidance.TO_BE_ARCHIVED =>
      val r = TO_BE_ARCHIVED
      r
    case software.amazon.awssdk.services.sagemaker.model.VendorGuidance.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.VendorGuidance {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VendorGuidance =
      software.amazon.awssdk.services.sagemaker.model.VendorGuidance.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_PROVIDED extends zio.aws.sagemaker.model.VendorGuidance {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VendorGuidance =
      software.amazon.awssdk.services.sagemaker.model.VendorGuidance.NOT_PROVIDED
  }
  case object STABLE extends zio.aws.sagemaker.model.VendorGuidance {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VendorGuidance =
      software.amazon.awssdk.services.sagemaker.model.VendorGuidance.STABLE
  }
  case object TO_BE_ARCHIVED extends zio.aws.sagemaker.model.VendorGuidance {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VendorGuidance =
      software.amazon.awssdk.services.sagemaker.model.VendorGuidance.TO_BE_ARCHIVED
  }
  case object ARCHIVED extends zio.aws.sagemaker.model.VendorGuidance {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VendorGuidance =
      software.amazon.awssdk.services.sagemaker.model.VendorGuidance.ARCHIVED
  }
}
