package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  AutoMLMaxResults,
  AutoMLNameContains,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAutoMlJobsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimeAfter: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimeBefore: Optional[Timestamp] = Optional.Absent,
    nameContains: Optional[AutoMLNameContains] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.AutoMLJobStatus] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.AutoMLSortOrder] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.AutoMLSortBy] = Optional.Absent,
    maxResults: Optional[AutoMLMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest = {
    import ListAutoMlJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        nameContains.map(value =>
          AutoMLNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => AutoMLMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAutoMlJobsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAutoMlJobsRequest.wrap(buildAwsValue())
}
object ListAutoMlJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAutoMlJobsRequest =
      zio.aws.sagemaker.model.ListAutoMlJobsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        nameContains.map(value => value),
        statusEquals.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def lastModifiedTimeAfter: Optional[Timestamp]
    def lastModifiedTimeBefore: Optional[Timestamp]
    def nameContains: Optional[AutoMLNameContains]
    def statusEquals: Optional[zio.aws.sagemaker.model.AutoMLJobStatus]
    def sortOrder: Optional[zio.aws.sagemaker.model.AutoMLSortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.AutoMLSortBy]
    def maxResults: Optional[AutoMLMaxResults]
    def nextToken: Optional[NextToken]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getNameContains: ZIO[Any, AwsError, AutoMLNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, AutoMLMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
  ) extends zio.aws.sagemaker.model.ListAutoMlJobsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeAfter: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val nameContains: Optional[AutoMLNameContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AutoMLNameContains(value)
        )
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.AutoMLJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.AutoMLJobStatus.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.AutoMLSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.AutoMLSortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.AutoMLSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.AutoMLSortBy.wrap(value))
    override val maxResults: Optional[AutoMLMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
  ): zio.aws.sagemaker.model.ListAutoMlJobsRequest.ReadOnly = new Wrapper(impl)
}
