package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HyperParameterTuningJobStrategyConfig(
    hyperbandStrategyConfig: Optional[
      zio.aws.sagemaker.model.HyperbandStrategyConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyConfig = {
    import HyperParameterTuningJobStrategyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyConfig
      .builder()
      .optionallyWith(
        hyperbandStrategyConfig.map(value => value.buildAwsValue())
      )(_.hyperbandStrategyConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobStrategyConfig.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobStrategyConfig
      .wrap(buildAwsValue())
}
object HyperParameterTuningJobStrategyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTuningJobStrategyConfig =
      zio.aws.sagemaker.model.HyperParameterTuningJobStrategyConfig(
        hyperbandStrategyConfig.map(value => value.asEditable)
      )
    def hyperbandStrategyConfig
        : Optional[zio.aws.sagemaker.model.HyperbandStrategyConfig.ReadOnly]
    def getHyperbandStrategyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperbandStrategyConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hyperbandStrategyConfig",
      hyperbandStrategyConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyConfig
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobStrategyConfig.ReadOnly {
    override val hyperbandStrategyConfig
        : Optional[zio.aws.sagemaker.model.HyperbandStrategyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperbandStrategyConfig())
        .map(value =>
          zio.aws.sagemaker.model.HyperbandStrategyConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyConfig
  ): zio.aws.sagemaker.model.HyperParameterTuningJobStrategyConfig.ReadOnly =
    new Wrapper(impl)
}
