package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  HyperParameterValue,
  HyperParameterKey,
  HyperParameterTrainingJobDefinitionName
}
import scala.jdk.CollectionConverters.*
final case class HyperParameterTrainingJobDefinition(
    definitionName: Optional[HyperParameterTrainingJobDefinitionName] =
      Optional.Absent,
    tuningObjective: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective
    ] = Optional.Absent,
    hyperParameterRanges: Optional[zio.aws.sagemaker.model.ParameterRanges] =
      Optional.Absent,
    staticHyperParameters: Optional[
      Map[HyperParameterKey, HyperParameterValue]
    ] = Optional.Absent,
    algorithmSpecification: zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification,
    roleArn: RoleArn,
    inputDataConfig: Optional[Iterable[zio.aws.sagemaker.model.Channel]] =
      Optional.Absent,
    vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig] = Optional.Absent,
    outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig,
    resourceConfig: Optional[zio.aws.sagemaker.model.ResourceConfig] =
      Optional.Absent,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition,
    enableNetworkIsolation: Optional[Boolean] = Optional.Absent,
    enableInterContainerTrafficEncryption: Optional[Boolean] = Optional.Absent,
    enableManagedSpotTraining: Optional[Boolean] = Optional.Absent,
    checkpointConfig: Optional[zio.aws.sagemaker.model.CheckpointConfig] =
      Optional.Absent,
    retryStrategy: Optional[zio.aws.sagemaker.model.RetryStrategy] =
      Optional.Absent,
    hyperParameterTuningResourceConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningResourceConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition = {
    import HyperParameterTrainingJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
      .builder()
      .optionallyWith(
        definitionName.map(value =>
          HyperParameterTrainingJobDefinitionName.unwrap(
            value
          ): java.lang.String
        )
      )(_.definitionName)
      .optionallyWith(tuningObjective.map(value => value.buildAwsValue()))(
        _.tuningObjective
      )
      .optionallyWith(hyperParameterRanges.map(value => value.buildAwsValue()))(
        _.hyperParameterRanges
      )
      .optionallyWith(
        staticHyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HyperParameterKey.unwrap(
                key
              ): java.lang.String) -> (HyperParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.staticHyperParameters)
      .algorithmSpecification(algorithmSpecification.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableManagedSpotTraining.map(value => value: java.lang.Boolean)
      )(_.enableManagedSpotTraining)
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(
        hyperParameterTuningResourceConfig.map(value => value.buildAwsValue())
      )(_.hyperParameterTuningResourceConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition
      .wrap(buildAwsValue())
}
object HyperParameterTrainingJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition =
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition(
        definitionName.map(value => value),
        tuningObjective.map(value => value.asEditable),
        hyperParameterRanges.map(value => value.asEditable),
        staticHyperParameters.map(value => value),
        algorithmSpecification.asEditable,
        roleArn,
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        outputDataConfig.asEditable,
        resourceConfig.map(value => value.asEditable),
        stoppingCondition.asEditable,
        enableNetworkIsolation.map(value => value),
        enableInterContainerTrafficEncryption.map(value => value),
        enableManagedSpotTraining.map(value => value),
        checkpointConfig.map(value => value.asEditable),
        retryStrategy.map(value => value.asEditable),
        hyperParameterTuningResourceConfig.map(value => value.asEditable)
      )
    def definitionName: Optional[HyperParameterTrainingJobDefinitionName]
    def tuningObjective: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ]
    def hyperParameterRanges
        : Optional[zio.aws.sagemaker.model.ParameterRanges.ReadOnly]
    def staticHyperParameters
        : Optional[Map[HyperParameterKey, HyperParameterValue]]
    def algorithmSpecification
        : zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly
    def roleArn: RoleArn
    def inputDataConfig
        : Optional[List[zio.aws.sagemaker.model.Channel.ReadOnly]]
    def vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig.ReadOnly
    def resourceConfig
        : Optional[zio.aws.sagemaker.model.ResourceConfig.ReadOnly]
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def enableNetworkIsolation: Optional[Boolean]
    def enableInterContainerTrafficEncryption: Optional[Boolean]
    def enableManagedSpotTraining: Optional[Boolean]
    def checkpointConfig
        : Optional[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly]
    def retryStrategy: Optional[zio.aws.sagemaker.model.RetryStrategy.ReadOnly]
    def hyperParameterTuningResourceConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.ReadOnly
    ]
    def getDefinitionName
        : ZIO[Any, AwsError, HyperParameterTrainingJobDefinitionName] =
      AwsError.unwrapOptionField("definitionName", definitionName)
    def getTuningObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("tuningObjective", tuningObjective)
    def getHyperParameterRanges
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ParameterRanges.ReadOnly] =
      AwsError.unwrapOptionField("hyperParameterRanges", hyperParameterRanges)
    def getStaticHyperParameters
        : ZIO[Any, AwsError, Map[HyperParameterKey, HyperParameterValue]] =
      AwsError.unwrapOptionField("staticHyperParameters", staticHyperParameters)
    def getAlgorithmSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly
    ] = ZIO.succeed(algorithmSpecification)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getInputDataConfig
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getResourceConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableManagedSpotTraining: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableManagedSpotTraining", enableManagedSpotTraining)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getHyperParameterTuningResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hyperParameterTuningResourceConfig",
      hyperParameterTuningResourceConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
  ) extends zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly {
    override val definitionName
        : Optional[HyperParameterTrainingJobDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definitionName())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .HyperParameterTrainingJobDefinitionName(value)
        )
    override val tuningObjective: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tuningObjective())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobObjective.wrap(value)
      )
    override val hyperParameterRanges
        : Optional[zio.aws.sagemaker.model.ParameterRanges.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameterRanges())
        .map(value => zio.aws.sagemaker.model.ParameterRanges.wrap(value))
    override val staticHyperParameters
        : Optional[Map[HyperParameterKey, HyperParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staticHyperParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.HyperParameterKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
            })
            .toMap
        )
    override val algorithmSpecification
        : zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly =
      zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification
        .wrap(impl.algorithmSpecification())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val inputDataConfig
        : Optional[List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Channel.wrap(item)
          }.toList
        )
    override val vpcConfig
        : Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val outputDataConfig
        : zio.aws.sagemaker.model.OutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val resourceConfig
        : Optional[zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceConfig())
        .map(value => zio.aws.sagemaker.model.ResourceConfig.wrap(value))
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
    override val enableNetworkIsolation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNetworkIsolation())
        .map(value => value: Boolean)
    override val enableInterContainerTrafficEncryption: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableInterContainerTrafficEncryption())
        .map(value => value: Boolean)
    override val enableManagedSpotTraining: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableManagedSpotTraining())
        .map(value => value: Boolean)
    override val checkpointConfig
        : Optional[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointConfig())
        .map(value => zio.aws.sagemaker.model.CheckpointConfig.wrap(value))
    override val retryStrategy
        : Optional[zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryStrategy())
        .map(value => zio.aws.sagemaker.model.RetryStrategy.wrap(value))
    override val hyperParameterTuningResourceConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperParameterTuningResourceConfig())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningResourceConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
  ): zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly =
    new Wrapper(impl)
}
