package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentName
import scala.jdk.CollectionConverters.*
final case class DescribeInferenceExperimentRequest(
    name: InferenceExperimentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest = {
    import DescribeInferenceExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeInferenceExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeInferenceExperimentRequest
      .wrap(buildAwsValue())
}
object DescribeInferenceExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeInferenceExperimentRequest =
      zio.aws.sagemaker.model.DescribeInferenceExperimentRequest(name)
    def name: InferenceExperimentName
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest
  ) extends zio.aws.sagemaker.model.DescribeInferenceExperimentRequest.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest
  ): zio.aws.sagemaker.model.DescribeInferenceExperimentRequest.ReadOnly =
    new Wrapper(impl)
}
