package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointName
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointRequest(endpointName: EndpointName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest = {
    import DescribeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeEndpointRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeEndpointRequest.wrap(buildAwsValue())
}
object DescribeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEndpointRequest =
      zio.aws.sagemaker.model.DescribeEndpointRequest(endpointName)
    def endpointName: EndpointName
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest
  ) extends zio.aws.sagemaker.model.DescribeEndpointRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest
  ): zio.aws.sagemaker.model.DescribeEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
