package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelCardArn
import scala.jdk.CollectionConverters.*
final case class CreateModelCardResponse(modelCardArn: ModelCardArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse = {
    import CreateModelCardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse
      .builder()
      .modelCardArn(ModelCardArn.unwrap(modelCardArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelCardResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelCardResponse.wrap(buildAwsValue())
}
object CreateModelCardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelCardResponse =
      zio.aws.sagemaker.model.CreateModelCardResponse(modelCardArn)
    def modelCardArn: ModelCardArn
    def getModelCardArn: ZIO[Any, Nothing, ModelCardArn] =
      ZIO.succeed(modelCardArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse
  ) extends zio.aws.sagemaker.model.CreateModelCardResponse.ReadOnly {
    override val modelCardArn: ModelCardArn =
      zio.aws.sagemaker.model.primitives.ModelCardArn(impl.modelCardArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse
  ): zio.aws.sagemaker.model.CreateModelCardResponse.ReadOnly = new Wrapper(
    impl
  )
}
