package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ValidationFraction
import scala.jdk.CollectionConverters.*
final case class AutoMLDataSplitConfig(
    validationFraction: Optional[ValidationFraction] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig = {
    import AutoMLDataSplitConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig
      .builder()
      .optionallyWith(
        validationFraction.map(value =>
          ValidationFraction.unwrap(value): java.lang.Float
        )
      )(_.validationFraction)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLDataSplitConfig.wrap(buildAwsValue())
}
object AutoMLDataSplitConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLDataSplitConfig =
      zio.aws.sagemaker.model
        .AutoMLDataSplitConfig(validationFraction.map(value => value))
    def validationFraction: Optional[ValidationFraction]
    def getValidationFraction: ZIO[Any, AwsError, ValidationFraction] =
      AwsError.unwrapOptionField("validationFraction", validationFraction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig
  ) extends zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly {
    override val validationFraction: Optional[ValidationFraction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationFraction())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ValidationFraction(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig
  ): zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly = new Wrapper(impl)
}
