package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  String256,
  ExperimentEntityName,
  ArtifactArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ArtifactSummary(
    artifactArn: Optional[ArtifactArn] = Optional.Absent,
    artifactName: Optional[ExperimentEntityName] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ArtifactSource] = Optional.Absent,
    artifactType: Optional[String256] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ArtifactSummary = {
    import ArtifactSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .optionallyWith(
        artifactName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.artifactName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        artifactType.map(value => String256.unwrap(value): java.lang.String)
      )(_.artifactType)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ArtifactSummary.ReadOnly =
    zio.aws.sagemaker.model.ArtifactSummary.wrap(buildAwsValue())
}
object ArtifactSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ArtifactSummary =
      zio.aws.sagemaker.model.ArtifactSummary(
        artifactArn.map(value => value),
        artifactName.map(value => value),
        source.map(value => value.asEditable),
        artifactType.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def artifactArn: Optional[ArtifactArn]
    def artifactName: Optional[ExperimentEntityName]
    def source: Optional[zio.aws.sagemaker.model.ArtifactSource.ReadOnly]
    def artifactType: Optional[String256]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
    def getArtifactName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("artifactName", artifactName)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getArtifactType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("artifactType", artifactType)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
  ) extends zio.aws.sagemaker.model.ArtifactSummary.ReadOnly {
    override val artifactArn: Optional[ArtifactArn] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
    override val artifactName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ArtifactSource.wrap(value))
    override val artifactType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSummary
  ): zio.aws.sagemaker.model.ArtifactSummary.ReadOnly = new Wrapper(impl)
}
