package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TrainingJobEarlyStoppingType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType
}
object TrainingJobEarlyStoppingType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType
  ): zio.aws.sagemaker.model.TrainingJobEarlyStoppingType = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType.OFF =>
      val r = Off
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType.AUTO =>
      val r = Auto
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrainingJobEarlyStoppingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType.UNKNOWN_TO_SDK_VERSION
  }
  case object Off extends zio.aws.sagemaker.model.TrainingJobEarlyStoppingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType.OFF
  }
  case object Auto
      extends zio.aws.sagemaker.model.TrainingJobEarlyStoppingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType.AUTO
  }
}
