package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentName
import scala.jdk.CollectionConverters.*
final case class StartInferenceExperimentRequest(
    name: InferenceExperimentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest = {
    import StartInferenceExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartInferenceExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.StartInferenceExperimentRequest
      .wrap(buildAwsValue())
}
object StartInferenceExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartInferenceExperimentRequest =
      zio.aws.sagemaker.model.StartInferenceExperimentRequest(name)
    def name: InferenceExperimentName
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest
  ) extends zio.aws.sagemaker.model.StartInferenceExperimentRequest.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest
  ): zio.aws.sagemaker.model.StartInferenceExperimentRequest.ReadOnly =
    new Wrapper(impl)
}
