package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  Integer,
  ModelCardArn,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ModelCardVersionSummary(
    modelCardName: EntityName,
    modelCardArn: ModelCardArn,
    modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus,
    modelCardVersion: Integer,
    creationTime: Timestamp,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary = {
    import ModelCardVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary
      .builder()
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .modelCardArn(ModelCardArn.unwrap(modelCardArn): java.lang.String)
      .modelCardStatus(modelCardStatus.unwrap)
      .modelCardVersion(modelCardVersion: java.lang.Integer)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelCardVersionSummary.wrap(buildAwsValue())
}
object ModelCardVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelCardVersionSummary =
      zio.aws.sagemaker.model.ModelCardVersionSummary(
        modelCardName,
        modelCardArn,
        modelCardStatus,
        modelCardVersion,
        creationTime,
        lastModifiedTime.map(value => value)
      )
    def modelCardName: EntityName
    def modelCardArn: ModelCardArn
    def modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus
    def modelCardVersion: Integer
    def creationTime: Timestamp
    def lastModifiedTime: Optional[Timestamp]
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
    def getModelCardArn: ZIO[Any, Nothing, ModelCardArn] =
      ZIO.succeed(modelCardArn)
    def getModelCardStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelCardStatus] =
      ZIO.succeed(modelCardStatus)
    def getModelCardVersion: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(modelCardVersion)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary
  ) extends zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly {
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
    override val modelCardArn: ModelCardArn =
      zio.aws.sagemaker.model.primitives.ModelCardArn(impl.modelCardArn())
    override val modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus =
      zio.aws.sagemaker.model.ModelCardStatus.wrap(impl.modelCardStatus())
    override val modelCardVersion: Integer = impl.modelCardVersion(): Integer
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary
  ): zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
