package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListPipelineExecutionStepsResponse(
    pipelineExecutionSteps: Optional[
      Iterable[zio.aws.sagemaker.model.PipelineExecutionStep]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse = {
    import ListPipelineExecutionStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse
      .builder()
      .optionallyWith(
        pipelineExecutionSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineExecutionSteps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse
      .wrap(buildAwsValue())
}
object ListPipelineExecutionStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse =
      zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse(
        pipelineExecutionSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelineExecutionSteps
        : Optional[List[zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPipelineExecutionSteps: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pipelineExecutionSteps",
      pipelineExecutionSteps
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse
  ) extends zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly {
    override val pipelineExecutionSteps: Optional[
      List[zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineExecutionSteps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.PipelineExecutionStep.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse
  ): zio.aws.sagemaker.model.ListPipelineExecutionStepsResponse.ReadOnly =
    new Wrapper(impl)
}
