package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDeviceFleetsResponse(
    deviceFleetSummaries: Iterable[zio.aws.sagemaker.model.DeviceFleetSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse = {
    import ListDeviceFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse
      .builder()
      .deviceFleetSummaries(deviceFleetSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListDeviceFleetsResponse.wrap(buildAwsValue())
}
object ListDeviceFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListDeviceFleetsResponse =
      zio.aws.sagemaker.model.ListDeviceFleetsResponse(
        deviceFleetSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def deviceFleetSummaries
        : List[zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDeviceFleetSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly
    ]] = ZIO.succeed(deviceFleetSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse
  ) extends zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly {
    override val deviceFleetSummaries
        : List[zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly] = impl
      .deviceFleetSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.DeviceFleetSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse
  ): zio.aws.sagemaker.model.ListDeviceFleetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
