package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SpaceName,
  DomainId,
  ExpiresInSeconds,
  SessionExpirationDurationInSeconds,
  UserProfileName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreatePresignedDomainUrlRequest(
    domainId: DomainId,
    userProfileName: UserProfileName,
    sessionExpirationDurationInSeconds: Optional[
      SessionExpirationDurationInSeconds
    ] = Optional.Absent,
    expiresInSeconds: Optional[ExpiresInSeconds] = Optional.Absent,
    spaceName: Optional[SpaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest = {
    import CreatePresignedDomainUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .optionallyWith(
        sessionExpirationDurationInSeconds.map(value =>
          SessionExpirationDurationInSeconds.unwrap(value): Integer
        )
      )(_.sessionExpirationDurationInSeconds)
      .optionallyWith(
        expiresInSeconds.map(value => ExpiresInSeconds.unwrap(value): Integer)
      )(_.expiresInSeconds)
      .optionallyWith(
        spaceName.map(value => SpaceName.unwrap(value): java.lang.String)
      )(_.spaceName)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreatePresignedDomainUrlRequest.ReadOnly =
    zio.aws.sagemaker.model.CreatePresignedDomainUrlRequest
      .wrap(buildAwsValue())
}
object CreatePresignedDomainUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreatePresignedDomainUrlRequest =
      zio.aws.sagemaker.model.CreatePresignedDomainUrlRequest(
        domainId,
        userProfileName,
        sessionExpirationDurationInSeconds.map(value => value),
        expiresInSeconds.map(value => value),
        spaceName.map(value => value)
      )
    def domainId: DomainId
    def userProfileName: UserProfileName
    def sessionExpirationDurationInSeconds
        : Optional[SessionExpirationDurationInSeconds]
    def expiresInSeconds: Optional[ExpiresInSeconds]
    def spaceName: Optional[SpaceName]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
    def getSessionExpirationDurationInSeconds
        : ZIO[Any, AwsError, SessionExpirationDurationInSeconds] =
      AwsError.unwrapOptionField(
        "sessionExpirationDurationInSeconds",
        sessionExpirationDurationInSeconds
      )
    def getExpiresInSeconds: ZIO[Any, AwsError, ExpiresInSeconds] =
      AwsError.unwrapOptionField("expiresInSeconds", expiresInSeconds)
    def getSpaceName: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceName", spaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest
  ) extends zio.aws.sagemaker.model.CreatePresignedDomainUrlRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
    override val sessionExpirationDurationInSeconds
        : Optional[SessionExpirationDurationInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionExpirationDurationInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .SessionExpirationDurationInSeconds(value)
      )
    override val expiresInSeconds: Optional[ExpiresInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiresInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExpiresInSeconds(value)
        )
    override val spaceName: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest
  ): zio.aws.sagemaker.model.CreatePresignedDomainUrlRequest.ReadOnly =
    new Wrapper(impl)
}
