package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RecommendationJobArn
import scala.jdk.CollectionConverters.*
final case class CreateInferenceRecommendationsJobResponse(
    jobArn: RecommendationJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse = {
    import CreateInferenceRecommendationsJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse
      .builder()
      .jobArn(RecommendationJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse
      .wrap(buildAwsValue())
}
object CreateInferenceRecommendationsJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse =
      zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse(jobArn)
    def jobArn: RecommendationJobArn
    def getJobArn: ZIO[Any, Nothing, RecommendationJobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse
  ) extends zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly {
    override val jobArn: RecommendationJobArn =
      zio.aws.sagemaker.model.primitives.RecommendationJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse
  ): zio.aws.sagemaker.model.CreateInferenceRecommendationsJobResponse.ReadOnly =
    new Wrapper(impl)
}
