package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionArn
import scala.jdk.CollectionConverters.*
final case class CreateDataQualityJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse = {
    import CreateDataQualityJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateDataQualityJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse =
      zio.aws.sagemaker.model
        .CreateDataQualityJobDefinitionResponse(jobDefinitionArn)
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse
  ): zio.aws.sagemaker.model.CreateDataQualityJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
