package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  WorkforceVpcEndpointId,
  WorkforceSubnetId,
  WorkforceSecurityGroupId,
  WorkforceVpcId
}
import scala.jdk.CollectionConverters.*
final case class WorkforceVpcConfigResponse(
    vpcId: WorkforceVpcId,
    securityGroupIds: Iterable[WorkforceSecurityGroupId],
    subnets: Iterable[WorkforceSubnetId],
    vpcEndpointId: Optional[WorkforceVpcEndpointId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigResponse = {
    import WorkforceVpcConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigResponse
      .builder()
      .vpcId(WorkforceVpcId.unwrap(vpcId): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        WorkforceSecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnets(subnets.map { item =>
        WorkforceSubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        vpcEndpointId.map(value =>
          WorkforceVpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.WorkforceVpcConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.WorkforceVpcConfigResponse.wrap(buildAwsValue())
}
object WorkforceVpcConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.WorkforceVpcConfigResponse =
      zio.aws.sagemaker.model.WorkforceVpcConfigResponse(
        vpcId,
        securityGroupIds,
        subnets,
        vpcEndpointId.map(value => value)
      )
    def vpcId: WorkforceVpcId
    def securityGroupIds: List[WorkforceSecurityGroupId]
    def subnets: List[WorkforceSubnetId]
    def vpcEndpointId: Optional[WorkforceVpcEndpointId]
    def getVpcId: ZIO[Any, Nothing, WorkforceVpcId] = ZIO.succeed(vpcId)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[WorkforceSecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnets: ZIO[Any, Nothing, List[WorkforceSubnetId]] =
      ZIO.succeed(subnets)
    def getVpcEndpointId: ZIO[Any, AwsError, WorkforceVpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigResponse
  ) extends zio.aws.sagemaker.model.WorkforceVpcConfigResponse.ReadOnly {
    override val vpcId: WorkforceVpcId =
      zio.aws.sagemaker.model.primitives.WorkforceVpcId(impl.vpcId())
    override val securityGroupIds: List[WorkforceSecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.WorkforceSecurityGroupId(item)
      }
      .toList
    override val subnets: List[WorkforceSubnetId] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.WorkforceSubnetId(item)
      }
      .toList
    override val vpcEndpointId: Optional[WorkforceVpcEndpointId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointId())
        .map(value =>
          zio.aws.sagemaker.model.primitives.WorkforceVpcEndpointId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigResponse
  ): zio.aws.sagemaker.model.WorkforceVpcConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
