package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{String40, AssociationEntityArn}
import scala.jdk.CollectionConverters.*
final case class Vertex(
    arn: Optional[AssociationEntityArn] = Optional.Absent,
    `type`: Optional[String40] = Optional.Absent,
    lineageType: Optional[zio.aws.sagemaker.model.LineageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Vertex = {
    import Vertex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Vertex
      .builder()
      .optionallyWith(
        arn.map(value => AssociationEntityArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        `type`.map(value => String40.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(lineageType.map(value => value.unwrap))(_.lineageType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Vertex.ReadOnly =
    zio.aws.sagemaker.model.Vertex.wrap(buildAwsValue())
}
object Vertex {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Vertex] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Vertex =
      zio.aws.sagemaker.model.Vertex(
        arn.map(value => value),
        `type`.map(value => value),
        lineageType.map(value => value)
      )
    def arn: Optional[AssociationEntityArn]
    def `type`: Optional[String40]
    def lineageType: Optional[zio.aws.sagemaker.model.LineageType]
    def getArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, String40] =
      AwsError.unwrapOptionField("type", `type`)
    def getLineageType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.LineageType] =
      AwsError.unwrapOptionField("lineageType", lineageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Vertex
  ) extends zio.aws.sagemaker.model.Vertex.ReadOnly {
    override val arn: Optional[AssociationEntityArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
      )
    override val `type`: Optional[String40] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.sagemaker.model.primitives.String40(value))
    override val lineageType: Optional[zio.aws.sagemaker.model.LineageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageType())
        .map(value => zio.aws.sagemaker.model.LineageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Vertex
  ): zio.aws.sagemaker.model.Vertex.ReadOnly = new Wrapper(impl)
}
