package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.WorkforceName
import scala.jdk.CollectionConverters.*
final case class UpdateWorkforceRequest(
    workforceName: WorkforceName,
    sourceIpConfig: Optional[zio.aws.sagemaker.model.SourceIpConfig] =
      Optional.Absent,
    oidcConfig: Optional[zio.aws.sagemaker.model.OidcConfig] = Optional.Absent,
    workforceVpcConfig: Optional[
      zio.aws.sagemaker.model.WorkforceVpcConfigRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest = {
    import UpdateWorkforceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest
      .builder()
      .workforceName(WorkforceName.unwrap(workforceName): java.lang.String)
      .optionallyWith(sourceIpConfig.map(value => value.buildAwsValue()))(
        _.sourceIpConfig
      )
      .optionallyWith(oidcConfig.map(value => value.buildAwsValue()))(
        _.oidcConfig
      )
      .optionallyWith(workforceVpcConfig.map(value => value.buildAwsValue()))(
        _.workforceVpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateWorkforceRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateWorkforceRequest.wrap(buildAwsValue())
}
object UpdateWorkforceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateWorkforceRequest =
      zio.aws.sagemaker.model.UpdateWorkforceRequest(
        workforceName,
        sourceIpConfig.map(value => value.asEditable),
        oidcConfig.map(value => value.asEditable),
        workforceVpcConfig.map(value => value.asEditable)
      )
    def workforceName: WorkforceName
    def sourceIpConfig
        : Optional[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly]
    def oidcConfig: Optional[zio.aws.sagemaker.model.OidcConfig.ReadOnly]
    def workforceVpcConfig
        : Optional[zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly]
    def getWorkforceName: ZIO[Any, Nothing, WorkforceName] =
      ZIO.succeed(workforceName)
    def getSourceIpConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      AwsError.unwrapOptionField("sourceIpConfig", sourceIpConfig)
    def getOidcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.OidcConfig.ReadOnly] =
      AwsError.unwrapOptionField("oidcConfig", oidcConfig)
    def getWorkforceVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly
    ] = AwsError.unwrapOptionField("workforceVpcConfig", workforceVpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest
  ) extends zio.aws.sagemaker.model.UpdateWorkforceRequest.ReadOnly {
    override val workforceName: WorkforceName =
      zio.aws.sagemaker.model.primitives.WorkforceName(impl.workforceName())
    override val sourceIpConfig
        : Optional[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIpConfig())
        .map(value => zio.aws.sagemaker.model.SourceIpConfig.wrap(value))
    override val oidcConfig
        : Optional[zio.aws.sagemaker.model.OidcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oidcConfig())
        .map(value => zio.aws.sagemaker.model.OidcConfig.wrap(value))
    override val workforceVpcConfig
        : Optional[zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workforceVpcConfig())
        .map(value =>
          zio.aws.sagemaker.model.WorkforceVpcConfigRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest
  ): zio.aws.sagemaker.model.UpdateWorkforceRequest.ReadOnly = new Wrapper(impl)
}
