package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelCardArn
import scala.jdk.CollectionConverters.*
final case class UpdateModelCardResponse(modelCardArn: ModelCardArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse = {
    import UpdateModelCardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse
      .builder()
      .modelCardArn(ModelCardArn.unwrap(modelCardArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateModelCardResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateModelCardResponse.wrap(buildAwsValue())
}
object UpdateModelCardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateModelCardResponse =
      zio.aws.sagemaker.model.UpdateModelCardResponse(modelCardArn)
    def modelCardArn: ModelCardArn
    def getModelCardArn: ZIO[Any, Nothing, ModelCardArn] =
      ZIO.succeed(modelCardArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse
  ) extends zio.aws.sagemaker.model.UpdateModelCardResponse.ReadOnly {
    override val modelCardArn: ModelCardArn =
      zio.aws.sagemaker.model.primitives.ModelCardArn(impl.modelCardArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse
  ): zio.aws.sagemaker.model.UpdateModelCardResponse.ReadOnly = new Wrapper(
    impl
  )
}
