package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  LastModifiedTime,
  CreationTime,
  SpaceName,
  DomainId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SpaceDetails(
    domainId: Optional[DomainId] = Optional.Absent,
    spaceName: Optional[SpaceName] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.SpaceStatus] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SpaceDetails = {
    import SpaceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SpaceDetails
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        spaceName.map(value => SpaceName.unwrap(value): java.lang.String)
      )(_.spaceName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SpaceDetails.ReadOnly =
    zio.aws.sagemaker.model.SpaceDetails.wrap(buildAwsValue())
}
object SpaceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SpaceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SpaceDetails =
      zio.aws.sagemaker.model.SpaceDetails(
        domainId.map(value => value),
        spaceName.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def domainId: Optional[DomainId]
    def spaceName: Optional[SpaceName]
    def status: Optional[zio.aws.sagemaker.model.SpaceStatus]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getSpaceName: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceName", spaceName)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.SpaceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SpaceDetails
  ) extends zio.aws.sagemaker.model.SpaceDetails.ReadOnly {
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val spaceName: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
    override val status: Optional[zio.aws.sagemaker.model.SpaceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.SpaceStatus.wrap(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SpaceDetails
  ): zio.aws.sagemaker.model.SpaceDetails.ReadOnly = new Wrapper(impl)
}
