package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  S3Uri,
  RedshiftDatabase,
  RedshiftUserName,
  KmsKeyId,
  RedshiftClusterId,
  RedshiftQueryString
}
import scala.jdk.CollectionConverters.*
final case class RedshiftDatasetDefinition(
    clusterId: RedshiftClusterId,
    database: RedshiftDatabase,
    dbUser: RedshiftUserName,
    queryString: RedshiftQueryString,
    clusterRoleArn: RoleArn,
    outputS3Uri: S3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    outputFormat: zio.aws.sagemaker.model.RedshiftResultFormat,
    outputCompression: Optional[
      zio.aws.sagemaker.model.RedshiftResultCompressionType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RedshiftDatasetDefinition = {
    import RedshiftDatasetDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RedshiftDatasetDefinition
      .builder()
      .clusterId(RedshiftClusterId.unwrap(clusterId): java.lang.String)
      .database(RedshiftDatabase.unwrap(database): java.lang.String)
      .dbUser(RedshiftUserName.unwrap(dbUser): java.lang.String)
      .queryString(RedshiftQueryString.unwrap(queryString): java.lang.String)
      .clusterRoleArn(RoleArn.unwrap(clusterRoleArn): java.lang.String)
      .outputS3Uri(S3Uri.unwrap(outputS3Uri): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .outputFormat(outputFormat.unwrap)
      .optionallyWith(outputCompression.map(value => value.unwrap))(
        _.outputCompression
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RedshiftDatasetDefinition.ReadOnly =
    zio.aws.sagemaker.model.RedshiftDatasetDefinition.wrap(buildAwsValue())
}
object RedshiftDatasetDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RedshiftDatasetDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RedshiftDatasetDefinition =
      zio.aws.sagemaker.model.RedshiftDatasetDefinition(
        clusterId,
        database,
        dbUser,
        queryString,
        clusterRoleArn,
        outputS3Uri,
        kmsKeyId.map(value => value),
        outputFormat,
        outputCompression.map(value => value)
      )
    def clusterId: RedshiftClusterId
    def database: RedshiftDatabase
    def dbUser: RedshiftUserName
    def queryString: RedshiftQueryString
    def clusterRoleArn: RoleArn
    def outputS3Uri: S3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def outputFormat: zio.aws.sagemaker.model.RedshiftResultFormat
    def outputCompression
        : Optional[zio.aws.sagemaker.model.RedshiftResultCompressionType]
    def getClusterId: ZIO[Any, Nothing, RedshiftClusterId] =
      ZIO.succeed(clusterId)
    def getDatabase: ZIO[Any, Nothing, RedshiftDatabase] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, Nothing, RedshiftUserName] = ZIO.succeed(dbUser)
    def getQueryString: ZIO[Any, Nothing, RedshiftQueryString] =
      ZIO.succeed(queryString)
    def getClusterRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(clusterRoleArn)
    def getOutputS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(outputS3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutputFormat
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RedshiftResultFormat] =
      ZIO.succeed(outputFormat)
    def getOutputCompression: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RedshiftResultCompressionType
    ] = AwsError.unwrapOptionField("outputCompression", outputCompression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RedshiftDatasetDefinition
  ) extends zio.aws.sagemaker.model.RedshiftDatasetDefinition.ReadOnly {
    override val clusterId: RedshiftClusterId =
      zio.aws.sagemaker.model.primitives.RedshiftClusterId(impl.clusterId())
    override val database: RedshiftDatabase =
      zio.aws.sagemaker.model.primitives.RedshiftDatabase(impl.database())
    override val dbUser: RedshiftUserName =
      zio.aws.sagemaker.model.primitives.RedshiftUserName(impl.dbUser())
    override val queryString: RedshiftQueryString =
      zio.aws.sagemaker.model.primitives.RedshiftQueryString(impl.queryString())
    override val clusterRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.clusterRoleArn())
    override val outputS3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.outputS3Uri())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val outputFormat: zio.aws.sagemaker.model.RedshiftResultFormat =
      zio.aws.sagemaker.model.RedshiftResultFormat.wrap(impl.outputFormat())
    override val outputCompression
        : Optional[zio.aws.sagemaker.model.RedshiftResultCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputCompression())
        .map(value =>
          zio.aws.sagemaker.model.RedshiftResultCompressionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RedshiftDatasetDefinition
  ): zio.aws.sagemaker.model.RedshiftDatasetDefinition.ReadOnly = new Wrapper(
    impl
  )
}
