package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ProcessingJobArn
import scala.jdk.CollectionConverters.*
final case class ProcessingJobStepMetadata(
    arn: Optional[ProcessingJobArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStepMetadata = {
    import ProcessingJobStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingJobStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => ProcessingJobArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingJobStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.ProcessingJobStepMetadata.wrap(buildAwsValue())
}
object ProcessingJobStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingJobStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingJobStepMetadata =
      zio.aws.sagemaker.model.ProcessingJobStepMetadata(arn.map(value => value))
    def arn: Optional[ProcessingJobArn]
    def getArn: ZIO[Any, AwsError, ProcessingJobArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJobStepMetadata
  ) extends zio.aws.sagemaker.model.ProcessingJobStepMetadata.ReadOnly {
    override val arn: Optional[ProcessingJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.ProcessingJobArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJobStepMetadata
  ): zio.aws.sagemaker.model.ProcessingJobStepMetadata.ReadOnly = new Wrapper(
    impl
  )
}
