package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModelDataQuality(
    statistics: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent,
    constraints: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDataQuality = {
    import ModelDataQuality.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDataQuality
      .builder()
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDataQuality.ReadOnly =
    zio.aws.sagemaker.model.ModelDataQuality.wrap(buildAwsValue())
}
object ModelDataQuality {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDataQuality
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDataQuality =
      zio.aws.sagemaker.model.ModelDataQuality(
        statistics.map(value => value.asEditable),
        constraints.map(value => value.asEditable)
      )
    def statistics: Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def constraints: Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDataQuality
  ) extends zio.aws.sagemaker.model.ModelDataQuality.ReadOnly {
    override val statistics
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val constraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDataQuality
  ): zio.aws.sagemaker.model.ModelDataQuality.ReadOnly = new Wrapper(impl)
}
