package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  MonitoringScheduleName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMonitoringAlertsRequest(
    monitoringScheduleName: MonitoringScheduleName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest = {
    import ListMonitoringAlertsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListMonitoringAlertsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringAlertsRequest.wrap(buildAwsValue())
}
object ListMonitoringAlertsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringAlertsRequest =
      zio.aws.sagemaker.model.ListMonitoringAlertsRequest(
        monitoringScheduleName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def monitoringScheduleName: MonitoringScheduleName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest
  ) extends zio.aws.sagemaker.model.ListMonitoringAlertsRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest
  ): zio.aws.sagemaker.model.ListMonitoringAlertsRequest.ReadOnly = new Wrapper(
    impl
  )
}
