package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEdgeDeploymentPlansResponse(
    edgeDeploymentPlanSummaries: Iterable[
      zio.aws.sagemaker.model.EdgeDeploymentPlanSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse = {
    import ListEdgeDeploymentPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse
      .builder()
      .edgeDeploymentPlanSummaries(edgeDeploymentPlanSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse.ReadOnly =
    zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse
      .wrap(buildAwsValue())
}
object ListEdgeDeploymentPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse =
      zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse(
        edgeDeploymentPlanSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def edgeDeploymentPlanSummaries
        : List[zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getEdgeDeploymentPlanSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly
    ]] = ZIO.succeed(edgeDeploymentPlanSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse
  ) extends zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse.ReadOnly {
    override val edgeDeploymentPlanSummaries
        : List[zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.ReadOnly] =
      impl
        .edgeDeploymentPlanSummaries()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.EdgeDeploymentPlanSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse
  ): zio.aws.sagemaker.model.ListEdgeDeploymentPlansResponse.ReadOnly =
    new Wrapper(impl)
}
