package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.LabelCounter
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LabelCounters(
    totalLabeled: Optional[LabelCounter] = Optional.Absent,
    humanLabeled: Optional[LabelCounter] = Optional.Absent,
    machineLabeled: Optional[LabelCounter] = Optional.Absent,
    failedNonRetryableError: Optional[LabelCounter] = Optional.Absent,
    unlabeled: Optional[LabelCounter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelCounters = {
    import LabelCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelCounters
      .builder()
      .optionallyWith(
        totalLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.totalLabeled)
      .optionallyWith(
        humanLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.humanLabeled)
      .optionallyWith(
        machineLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.machineLabeled)
      .optionallyWith(
        failedNonRetryableError.map(value =>
          LabelCounter.unwrap(value): Integer
        )
      )(_.failedNonRetryableError)
      .optionallyWith(
        unlabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.unlabeled)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelCounters.ReadOnly =
    zio.aws.sagemaker.model.LabelCounters.wrap(buildAwsValue())
}
object LabelCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelCounters =
      zio.aws.sagemaker.model.LabelCounters(
        totalLabeled.map(value => value),
        humanLabeled.map(value => value),
        machineLabeled.map(value => value),
        failedNonRetryableError.map(value => value),
        unlabeled.map(value => value)
      )
    def totalLabeled: Optional[LabelCounter]
    def humanLabeled: Optional[LabelCounter]
    def machineLabeled: Optional[LabelCounter]
    def failedNonRetryableError: Optional[LabelCounter]
    def unlabeled: Optional[LabelCounter]
    def getTotalLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("totalLabeled", totalLabeled)
    def getHumanLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("humanLabeled", humanLabeled)
    def getMachineLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("machineLabeled", machineLabeled)
    def getFailedNonRetryableError: ZIO[Any, AwsError, LabelCounter] = AwsError
      .unwrapOptionField("failedNonRetryableError", failedNonRetryableError)
    def getUnlabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("unlabeled", unlabeled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelCounters
  ) extends zio.aws.sagemaker.model.LabelCounters.ReadOnly {
    override val totalLabeled: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.totalLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val humanLabeled: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val machineLabeled: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.machineLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val failedNonRetryableError: Optional[LabelCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedNonRetryableError())
        .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val unlabeled: Optional[LabelCounter] = zio.aws.core.internal
      .optionalFromNullable(impl.unlabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelCounters
  ): zio.aws.sagemaker.model.LabelCounters.ReadOnly = new Wrapper(impl)
}
