package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ImageSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ImageSortOrder
}
object ImageSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ImageSortOrder
  ): zio.aws.sagemaker.model.ImageSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.ImageSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageSortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageSortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ImageSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ImageSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.sagemaker.model.ImageSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ImageSortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.sagemaker.model.ImageSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortOrder =
      software.amazon.awssdk.services.sagemaker.model.ImageSortOrder.DESCENDING
  }
}
