package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DriftCheckBias(
    configFile: Optional[zio.aws.sagemaker.model.FileSource] = Optional.Absent,
    preTrainingConstraints: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent,
    postTrainingConstraints: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckBias = {
    import DriftCheckBias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckBias
      .builder()
      .optionallyWith(configFile.map(value => value.buildAwsValue()))(
        _.configFile
      )
      .optionallyWith(
        preTrainingConstraints.map(value => value.buildAwsValue())
      )(_.preTrainingConstraints)
      .optionallyWith(
        postTrainingConstraints.map(value => value.buildAwsValue())
      )(_.postTrainingConstraints)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckBias.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckBias.wrap(buildAwsValue())
}
object DriftCheckBias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckBias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckBias =
      zio.aws.sagemaker.model.DriftCheckBias(
        configFile.map(value => value.asEditable),
        preTrainingConstraints.map(value => value.asEditable),
        postTrainingConstraints.map(value => value.asEditable)
      )
    def configFile: Optional[zio.aws.sagemaker.model.FileSource.ReadOnly]
    def preTrainingConstraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def postTrainingConstraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getConfigFile
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FileSource.ReadOnly] =
      AwsError.unwrapOptionField("configFile", configFile)
    def getPreTrainingConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField(
        "preTrainingConstraints",
        preTrainingConstraints
      )
    def getPostTrainingConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField(
        "postTrainingConstraints",
        postTrainingConstraints
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckBias
  ) extends zio.aws.sagemaker.model.DriftCheckBias.ReadOnly {
    override val configFile
        : Optional[zio.aws.sagemaker.model.FileSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configFile())
        .map(value => zio.aws.sagemaker.model.FileSource.wrap(value))
    override val preTrainingConstraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preTrainingConstraints())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val postTrainingConstraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postTrainingConstraints())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckBias
  ): zio.aws.sagemaker.model.DriftCheckBias.ReadOnly = new Wrapper(impl)
}
