package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  RoleArn,
  OnlineStoreTotalSizeBytes,
  FeatureGroupArn,
  FailureReason,
  LastModifiedTime,
  FeatureGroupName,
  Description,
  FeatureName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeFeatureGroupResponse(
    featureGroupArn: FeatureGroupArn,
    featureGroupName: FeatureGroupName,
    recordIdentifierFeatureName: FeatureName,
    eventTimeFeatureName: FeatureName,
    featureDefinitions: Iterable[zio.aws.sagemaker.model.FeatureDefinition],
    creationTime: CreationTime,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    onlineStoreConfig: Optional[zio.aws.sagemaker.model.OnlineStoreConfig] =
      Optional.Absent,
    offlineStoreConfig: Optional[zio.aws.sagemaker.model.OfflineStoreConfig] =
      Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    featureGroupStatus: Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      Optional.Absent,
    offlineStoreStatus: Optional[zio.aws.sagemaker.model.OfflineStoreStatus] =
      Optional.Absent,
    lastUpdateStatus: Optional[zio.aws.sagemaker.model.LastUpdateStatus] =
      Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    nextToken: NextToken,
    onlineStoreTotalSizeBytes: Optional[OnlineStoreTotalSizeBytes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse = {
    import DescribeFeatureGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
      .builder()
      .featureGroupArn(
        FeatureGroupArn.unwrap(featureGroupArn): java.lang.String
      )
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierFeatureName(
        FeatureName.unwrap(recordIdentifierFeatureName): java.lang.String
      )
      .eventTimeFeatureName(
        FeatureName.unwrap(eventTimeFeatureName): java.lang.String
      )
      .featureDefinitions(featureDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(onlineStoreConfig.map(value => value.buildAwsValue()))(
        _.onlineStoreConfig
      )
      .optionallyWith(offlineStoreConfig.map(value => value.buildAwsValue()))(
        _.offlineStoreConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(featureGroupStatus.map(value => value.unwrap))(
        _.featureGroupStatus
      )
      .optionallyWith(offlineStoreStatus.map(value => value.buildAwsValue()))(
        _.offlineStoreStatus
      )
      .optionallyWith(lastUpdateStatus.map(value => value.buildAwsValue()))(
        _.lastUpdateStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .optionallyWith(
        onlineStoreTotalSizeBytes.map(value =>
          OnlineStoreTotalSizeBytes.unwrap(value): java.lang.Long
        )
      )(_.onlineStoreTotalSizeBytes)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeFeatureGroupResponse.wrap(buildAwsValue())
}
object DescribeFeatureGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFeatureGroupResponse =
      zio.aws.sagemaker.model.DescribeFeatureGroupResponse(
        featureGroupArn,
        featureGroupName,
        recordIdentifierFeatureName,
        eventTimeFeatureName,
        featureDefinitions.map { item =>
          item.asEditable
        },
        creationTime,
        lastModifiedTime.map(value => value),
        onlineStoreConfig.map(value => value.asEditable),
        offlineStoreConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        featureGroupStatus.map(value => value),
        offlineStoreStatus.map(value => value.asEditable),
        lastUpdateStatus.map(value => value.asEditable),
        failureReason.map(value => value),
        description.map(value => value),
        nextToken,
        onlineStoreTotalSizeBytes.map(value => value)
      )
    def featureGroupArn: FeatureGroupArn
    def featureGroupName: FeatureGroupName
    def recordIdentifierFeatureName: FeatureName
    def eventTimeFeatureName: FeatureName
    def featureDefinitions
        : List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]
    def creationTime: CreationTime
    def lastModifiedTime: Optional[LastModifiedTime]
    def onlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly]
    def offlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly]
    def roleArn: Optional[RoleArn]
    def featureGroupStatus: Optional[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatus
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly]
    def lastUpdateStatus
        : Optional[zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly]
    def failureReason: Optional[FailureReason]
    def description: Optional[Description]
    def nextToken: NextToken
    def onlineStoreTotalSizeBytes: Optional[OnlineStoreTotalSizeBytes]
    def getFeatureGroupArn: ZIO[Any, Nothing, FeatureGroupArn] =
      ZIO.succeed(featureGroupArn)
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(recordIdentifierFeatureName)
    def getEventTimeFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(eventTimeFeatureName)
    def getFeatureDefinitions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = ZIO.succeed(featureDefinitions)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getOnlineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("onlineStoreConfig", onlineStoreConfig)
    def getOfflineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreConfig", offlineStoreConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureGroupStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField("featureGroupStatus", featureGroupStatus)
    def getOfflineStoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreStatus", offlineStoreStatus)
    def getLastUpdateStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly
    ] = AwsError.unwrapOptionField("lastUpdateStatus", lastUpdateStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
    def getOnlineStoreTotalSizeBytes
        : ZIO[Any, AwsError, OnlineStoreTotalSizeBytes] = AwsError
      .unwrapOptionField("onlineStoreTotalSizeBytes", onlineStoreTotalSizeBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
  ) extends zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly {
    override val featureGroupArn: FeatureGroupArn =
      zio.aws.sagemaker.model.primitives.FeatureGroupArn(impl.featureGroupArn())
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val recordIdentifierFeatureName: FeatureName =
      zio.aws.sagemaker.model.primitives
        .FeatureName(impl.recordIdentifierFeatureName())
    override val eventTimeFeatureName: FeatureName =
      zio.aws.sagemaker.model.primitives
        .FeatureName(impl.eventTimeFeatureName())
    override val featureDefinitions
        : List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly] = impl
      .featureDefinitions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.FeatureDefinition.wrap(item)
      }
      .toList
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val onlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlineStoreConfig())
        .map(value => zio.aws.sagemaker.model.OnlineStoreConfig.wrap(value))
    override val offlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offlineStoreConfig())
        .map(value => zio.aws.sagemaker.model.OfflineStoreConfig.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val featureGroupStatus
        : Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupStatus())
        .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatus
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offlineStoreStatus())
        .map(value => zio.aws.sagemaker.model.OfflineStoreStatus.wrap(value))
    override val lastUpdateStatus
        : Optional[zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatus())
        .map(value => zio.aws.sagemaker.model.LastUpdateStatus.wrap(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.Description(value))
    override val nextToken: NextToken =
      zio.aws.sagemaker.model.primitives.NextToken(impl.nextToken())
    override val onlineStoreTotalSizeBytes
        : Optional[OnlineStoreTotalSizeBytes] = zio.aws.core.internal
      .optionalFromNullable(impl.onlineStoreTotalSizeBytes())
      .map(value =>
        zio.aws.sagemaker.model.primitives.OnlineStoreTotalSizeBytes(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse
  ): zio.aws.sagemaker.model.DescribeFeatureGroupResponse.ReadOnly =
    new Wrapper(impl)
}
