package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  DeviceArn,
  ThingName,
  EdgeVersion,
  DeviceDescription,
  Timestamp,
  Integer,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeDeviceResponse(
    deviceArn: Optional[DeviceArn] = Optional.Absent,
    deviceName: EntityName,
    description: Optional[DeviceDescription] = Optional.Absent,
    deviceFleetName: EntityName,
    iotThingName: Optional[ThingName] = Optional.Absent,
    registrationTime: Timestamp,
    latestHeartbeat: Optional[Timestamp] = Optional.Absent,
    models: Optional[Iterable[zio.aws.sagemaker.model.EdgeModel]] =
      Optional.Absent,
    maxModels: Optional[Integer] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    agentVersion: Optional[EdgeVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse = {
    import DescribeDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
      .builder()
      .optionallyWith(
        deviceArn.map(value => DeviceArn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .deviceName(EntityName.unwrap(deviceName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DeviceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        iotThingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.iotThingName)
      .registrationTime(Timestamp.unwrap(registrationTime): Instant)
      .optionallyWith(
        latestHeartbeat.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestHeartbeat)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .optionallyWith(maxModels.map(value => value: java.lang.Integer))(
        _.maxModels
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        agentVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeDeviceResponse.wrap(buildAwsValue())
}
object DescribeDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDeviceResponse =
      zio.aws.sagemaker.model.DescribeDeviceResponse(
        deviceArn.map(value => value),
        deviceName,
        description.map(value => value),
        deviceFleetName,
        iotThingName.map(value => value),
        registrationTime,
        latestHeartbeat.map(value => value),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxModels.map(value => value),
        nextToken.map(value => value),
        agentVersion.map(value => value)
      )
    def deviceArn: Optional[DeviceArn]
    def deviceName: EntityName
    def description: Optional[DeviceDescription]
    def deviceFleetName: EntityName
    def iotThingName: Optional[ThingName]
    def registrationTime: Timestamp
    def latestHeartbeat: Optional[Timestamp]
    def models: Optional[List[zio.aws.sagemaker.model.EdgeModel.ReadOnly]]
    def maxModels: Optional[Integer]
    def nextToken: Optional[NextToken]
    def agentVersion: Optional[EdgeVersion]
    def getDeviceArn: ZIO[Any, AwsError, DeviceArn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(deviceName)
    def getDescription: ZIO[Any, AwsError, DeviceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getIotThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("iotThingName", iotThingName)
    def getRegistrationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(registrationTime)
    def getLatestHeartbeat: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestHeartbeat", latestHeartbeat)
    def getModels
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.EdgeModel.ReadOnly]] =
      AwsError.unwrapOptionField("models", models)
    def getMaxModels: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxModels", maxModels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAgentVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
  ) extends zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly {
    override val deviceArn: Optional[DeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.sagemaker.model.primitives.DeviceArn(value))
    override val deviceName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceName())
    override val description: Optional[DeviceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DeviceDescription(value)
        )
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val iotThingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.iotThingName())
      .map(value => zio.aws.sagemaker.model.primitives.ThingName(value))
    override val registrationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.registrationTime())
    override val latestHeartbeat: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestHeartbeat())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val models
        : Optional[List[zio.aws.sagemaker.model.EdgeModel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.EdgeModel.wrap(item)
          }.toList
        )
    override val maxModels: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxModels())
      .map(value => value: Integer)
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val agentVersion: Optional[EdgeVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.agentVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse
  ): zio.aws.sagemaker.model.DescribeDeviceResponse.ReadOnly = new Wrapper(impl)
}
