package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters.*
final case class DescribeDataQualityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest = {
    import DescribeDataQualityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object DescribeDataQualityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionRequest =
      zio.aws.sagemaker.model
        .DescribeDataQualityJobDefinitionRequest(jobDefinitionName)
    def jobDefinitionName: MonitoringJobDefinitionName
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest
  ): zio.aws.sagemaker.model.DescribeDataQualityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
