package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class DescribeCompilationJobRequest(compilationJobName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest = {
    import DescribeCompilationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest
      .builder()
      .compilationJobName(
        EntityName.unwrap(compilationJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeCompilationJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeCompilationJobRequest.wrap(buildAwsValue())
}
object DescribeCompilationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeCompilationJobRequest =
      zio.aws.sagemaker.model.DescribeCompilationJobRequest(compilationJobName)
    def compilationJobName: EntityName
    def getCompilationJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(compilationJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest
  ) extends zio.aws.sagemaker.model.DescribeCompilationJobRequest.ReadOnly {
    override val compilationJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.compilationJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest
  ): zio.aws.sagemaker.model.DescribeCompilationJobRequest.ReadOnly =
    new Wrapper(impl)
}
