package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ImageName
import scala.jdk.CollectionConverters.*
final case class DeleteImageRequest(imageName: ImageName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest = {
    import DeleteImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteImageRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteImageRequest.wrap(buildAwsValue())
}
object DeleteImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteImageRequest =
      zio.aws.sagemaker.model.DeleteImageRequest(imageName)
    def imageName: ImageName
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest
  ) extends zio.aws.sagemaker.model.DeleteImageRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest
  ): zio.aws.sagemaker.model.DeleteImageRequest.ReadOnly = new Wrapper(impl)
}
