package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class CreateEdgeDeploymentPlanRequest(
    edgeDeploymentPlanName: EntityName,
    modelConfigs: Iterable[zio.aws.sagemaker.model.EdgeDeploymentModelConfig],
    deviceFleetName: EntityName,
    stages: Optional[Iterable[zio.aws.sagemaker.model.DeploymentStage]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest = {
    import CreateEdgeDeploymentPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest
      .builder()
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .modelConfigs(modelConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        stages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stages)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateEdgeDeploymentPlanRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateEdgeDeploymentPlanRequest
      .wrap(buildAwsValue())
}
object CreateEdgeDeploymentPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEdgeDeploymentPlanRequest =
      zio.aws.sagemaker.model.CreateEdgeDeploymentPlanRequest(
        edgeDeploymentPlanName,
        modelConfigs.map { item =>
          item.asEditable
        },
        deviceFleetName,
        stages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def edgeDeploymentPlanName: EntityName
    def modelConfigs
        : List[zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly]
    def deviceFleetName: EntityName
    def stages: Optional[List[zio.aws.sagemaker.model.DeploymentStage.ReadOnly]]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getModelConfigs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly
    ]] = ZIO.succeed(modelConfigs)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getStages: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DeploymentStage.ReadOnly
    ]] = AwsError.unwrapOptionField("stages", stages)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest
  ) extends zio.aws.sagemaker.model.CreateEdgeDeploymentPlanRequest.ReadOnly {
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val modelConfigs
        : List[zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly] =
      impl
        .modelConfigs()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.EdgeDeploymentModelConfig.wrap(item)
        }
        .toList
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val stages
        : Optional[List[zio.aws.sagemaker.model.DeploymentStage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.DeploymentStage.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest
  ): zio.aws.sagemaker.model.CreateEdgeDeploymentPlanRequest.ReadOnly =
    new Wrapper(impl)
}
